#pragma once

//definice ukazatele na funkci pro zpracovani instrukce
typedef int (CALLBACK *EXEC_FUNC) (CFunctionInstance*,ScriptDependencies*); 

//*******************************************************************************************************************
//Trida ktera reprezentuje virtualni stroj ktery je schopen provadet instrukce skriptovaciho jazyka
//Obsahuje clenske funkce pomoci kterych jsou vykonavany jednotlive instrukce jazyka. Adresy techto funkci jsou
//ulozeny v tabulce na pozici ktera prislusi danemu bajtovemu kodu instrukce. Ziskani ukazatele na funkci se pak
//provadi prostym zadanim nactneho bajtoveho kodu instrukce jako indexu do teto tabulky
//*******************************************************************************************************************
class CVirtualMachine : public IVirtualMachine
{
private:
	ScriptDependencies*					m_ScriptDependencies;	//ukazatel na zdroje skriptu

	EXEC_FUNC*							m_Functions;	//pole ukazatelu na funkce ktere budou vykonavat kod
	DWORD								m_dwRef;		//pocet instanci tridy, souvisi s rozhranim IVirtualMachine	
private:
	//prototypy funkci pro zpracovani instrukci, nazvy jasne rikaji jakou instrukci dana funkce
	//vykonava, emuluje
	static int CALLBACK			 		Exec_nop(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_mul(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_neg(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_mod(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_sub(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_div(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_add(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_goto(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_ifeq(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_ifne(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_if_cmpeq(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_if_cmpgt(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_if_cmplt(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_if_cmple(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_if_cmpge(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_if_cmpne(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_return(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_vreturn(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_load(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_store(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_ldc_int(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_ldc_string(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_ldc_double(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_dup(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_pop(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_lcall(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_ecall(CFunctionInstance* func,ScriptDependencies* sd);
	
	static int CALLBACK					Exec_shl(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_shr(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_inc(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_dec(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_and(CFunctionInstance* func,ScriptDependencies* sd);
	static int CALLBACK					Exec_or(CFunctionInstance* func,ScriptDependencies* sd);
public:
	//konstruktor a destruktor
	CVirtualMachine(void);
	~CVirtualMachine(void);

	//inicializace virtualniho stroje, je nutne volat prvni
	void								Init(ScriptDependencies* scriptdependencies);
	//provedeni instrukci
	void								Run(CFunctionInstance*	function,int iMaxInstructions);
	//souvisi s rozhranim
	HRESULT								AddRef();
	HRESULT								Release();
};
